/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.items.instances;

import java.util.List;
import java.util.UUID;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityDecor;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartEngine;
import minecrafttransportsimulator.entities.instances.PartInteractable;
import minecrafttransportsimulator.entities.instances.PartSeat;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.components.IItemEntityInteractable;
import minecrafttransportsimulator.items.components.IItemFood;
import minecrafttransportsimulator.jsondefs.AJSONInteractableEntity;
import minecrafttransportsimulator.jsondefs.JSONItem;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPoleComponent;
import minecrafttransportsimulator.jsondefs.JSONPotionEffect;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketEntityGUIRequest;
import minecrafttransportsimulator.packets.instances.PacketEntityKeyChange;
import minecrafttransportsimulator.packets.instances.PacketGUIRequest;
import minecrafttransportsimulator.packets.instances.PacketPartEngine;
import minecrafttransportsimulator.packets.instances.PacketPartInteractable;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.LanguageSystem;

public class ItemItem
extends AItemPack<JSONItem>
implements IItemEntityInteractable,
IItemFood {
    public int pageNumber;
    public List<LanguageSystem.LanguageEntry> languageTitle;
    public List<LanguageSystem.LanguageEntry> languagePageTitle;
    public List<List<LanguageSystem.LanguageEntry>> languagePageText;
    private static PartEngine firstEngineClicked;
    private static PartInteractable firstPartClicked;
    public static final String KEY_UUID_TAG = "keyUUID";

    public ItemItem(JSONItem definition) {
        super(definition, null);
    }

    @Override
    public boolean canBreakBlocks() {
        return !((JSONItem)this.definition).item.type.equals((Object)JSONItem.ItemComponentType.WRENCH) && !((JSONItem)this.definition).item.type.equals((Object)JSONItem.ItemComponentType.SCREWDRIVER);
    }

    @Override
    public void addTooltipLines(List<String> tooltipLines, IWrapperNBT data) {
        super.addTooltipLines(tooltipLines, data);
        switch (((JSONItem)this.definition).item.type) {
            case SCANNER: {
                tooltipLines.add(LanguageSystem.ITEMINFO_SCANNER.getCurrentValue());
                break;
            }
            case WRENCH: {
                tooltipLines.add(LanguageSystem.ITEMINFO_WRENCH.getCurrentValue());
                break;
            }
            case SCREWDRIVER: {
                tooltipLines.add(LanguageSystem.ITEMINFO_SCREWDRIVER.getCurrentValue());
                break;
            }
            case PAINT_GUN: {
                tooltipLines.add(LanguageSystem.ITEMINFO_PAINTGUN.getCurrentValue());
                break;
            }
            case KEY: {
                tooltipLines.add(LanguageSystem.ITEMINFO_KEY.getCurrentValue());
                break;
            }
            case TICKET: {
                tooltipLines.add(LanguageSystem.ITEMINFO_TICKET.getCurrentValue());
                break;
            }
            case FUEL_HOSE: {
                tooltipLines.add(LanguageSystem.ITEMINFO_FUELHOSE.getCurrentValue());
                break;
            }
            case JUMPER_CABLES: {
                tooltipLines.add(LanguageSystem.ITEMINFO_JUMPERCABLES.getCurrentValue());
                break;
            }
            case JUMPER_PACK: {
                tooltipLines.add(LanguageSystem.ITEMINFO_JUMPERPACK.getCurrentValue());
                break;
            }
            case REPAIR_PACK: {
                if (((JSONItem)this.definition).repair.repairableParts != null) {
                    tooltipLines.add(LanguageSystem.ITEMINFO_REPAIRPACK_PART.getCurrentValue() + ((JSONItem)this.definition).repair.amount + " HP");
                    for (String partPrefix : ((JSONItem)this.definition).repair.repairableParts) {
                        if (!partPrefix.startsWith("engine")) continue;
                        tooltipLines.add(LanguageSystem.ITEMINFO_REPAIRPACK_ENGINE.getCurrentValue());
                    }
                } else {
                    tooltipLines.add(LanguageSystem.ITEMINFO_REPAIRPACK_VEHICLE.getCurrentValue() + ((JSONItem)this.definition).repair.amount + " HP");
                }
                if (!((JSONItem)this.definition).repair.canRepairTotaled) break;
                tooltipLines.add(LanguageSystem.ITEMINFO_REPAIRPACK_UNTOTAL.getCurrentValue());
                break;
            }
            case Y2K_BUTTON: {
                tooltipLines.add(LanguageSystem.ITEMINFO_Y2KBUTTON.getCurrentValue());
                break;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public IItemEntityInteractable.CallbackType doEntityInteraction(AEntityE_Interactable<?> entity, BoundingBox hitBox, IWrapperPlayer player, boolean rightClick) {
        vehicle = entity instanceof EntityVehicleF_Physics != false ? (EntityVehicleF_Physics)entity : (entity instanceof APart != false ? ((APart)entity).vehicleOn : null);
        switch (1.$SwitchMap$minecrafttransportsimulator$jsondefs$JSONItem$ItemComponentType[((JSONItem)this.definition).item.type.ordinal()]) {
            case 2: 
            case 3: {
                if (!entity.world.isClient()) {
                    if (vehicle == null || !vehicle.lockedVar.isActive) {
                        if (rightClick) {
                            if (player.isSneaking()) {
                                if (entity instanceof APart && entity.text.isEmpty()) {
                                    player.sendPacket(new PacketEntityGUIRequest(((APart)entity).masterEntity, player, PacketEntityGUIRequest.EntityGUIType.TEXT_EDITOR));
                                } else {
                                    player.sendPacket(new PacketEntityGUIRequest(entity, player, PacketEntityGUIRequest.EntityGUIType.TEXT_EDITOR));
                                }
                            } else if (vehicle != null) {
                                if (((Boolean)ConfigSystem.settings.general.devMode.value).booleanValue() && vehicle.allParts.contains(player.getEntityRiding())) {
                                    player.sendPacket(new PacketEntityGUIRequest(vehicle, player, PacketEntityGUIRequest.EntityGUIType.PACK_EXPORTER));
                                } else if (!vehicle.allParts.contains(player.getEntityRiding())) {
                                    player.sendPacket(new PacketEntityGUIRequest(vehicle, player, PacketEntityGUIRequest.EntityGUIType.INSTRUMENTS));
                                }
                            }
                        } else if (player.isSneaking()) {
                            if (!(vehicle == null || ((Boolean)ConfigSystem.settings.general.opPickupVehiclesOnly.value).booleanValue() && !player.isOP() || ((Boolean)ConfigSystem.settings.general.creativePickupVehiclesOnly.value).booleanValue() && !player.isCreative() || !entity.isValid)) {
                                vehicle.disconnectAllConnections();
                                vehicle.world.spawnItemStack(vehicle.getStack(), hitBox.globalCenter, null);
                                vehicle.remove();
                            }
                        } else if (entity instanceof APart) {
                            part = (APart)entity;
                            if (!part.isPermanent && part.isValid) {
                                partResult = part.checkForRemoval(player);
                                if (partResult != null) {
                                    player.sendPacket(new PacketPlayerChatMessage(player, partResult, new Object[0]));
                                    return IItemEntityInteractable.CallbackType.NONE;
                                }
                                part.entityOn.world.spawnItemStack(part.getStack(), part.position, null);
                                part.entityOn.removePart(part, true, true);
                            }
                        }
                    } else {
                        player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_VEHICLE_LOCKED, new Object[0]));
                    }
                }
                return IItemEntityInteractable.CallbackType.NONE;
            }
            case 4: {
                if (!entity.world.isClient() && rightClick) {
                    if (vehicle == null || !vehicle.lockedVar.isActive) {
                        player.sendPacket(new PacketEntityGUIRequest(entity, player, PacketEntityGUIRequest.EntityGUIType.PAINT_GUN));
                    } else {
                        player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_VEHICLE_LOCKED, new Object[0]));
                    }
                }
                return IItemEntityInteractable.CallbackType.NONE;
            }
            case 5: {
                if (vehicle != null && rightClick && !entity.world.isClient()) {
                    stack = player.getHeldStack();
                    data = stack.getData();
                    v0 = keyUUID = data != null ? data.getUUID("keyUUID") : null;
                    if (keyUUID == null) {
                        if (vehicle.keyUUID != null && !player.isOP()) {
                            player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_KEY_HASKEY, new Object[0]));
                        } else {
                            vehicle.keyUUID = keyUUID = UUID.randomUUID();
                            data = InterfaceManager.coreInterface.getNewNBTWrapper();
                            data.setUUID("keyUUID", keyUUID);
                            stack.setData(data);
                            player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_KEY_BIND, new Object[0]));
                            InterfaceManager.packetInterface.sendToAllClients(new PacketEntityKeyChange(vehicle, keyUUID));
                        }
                        return IItemEntityInteractable.CallbackType.NONE;
                    }
                    if (!keyUUID.equals(vehicle.keyUUID)) {
                        player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_KEY_WRONGKEY, new Object[0]));
                    } else {
                        if (entity instanceof PartSeat) {
                            return IItemEntityInteractable.CallbackType.SKIP;
                        }
                        if (vehicle.lockedVar.isActive) {
                            vehicle.toggleLock();
                            player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_KEY_UNLOCK, new Object[0]));
                            if (hitBox.definition != null && hitBox.definition.action != null && !entity.getOrCreateVariable((String)hitBox.definition.action.variable).isActive && hitBox.definition.action.variable.startsWith("door")) {
                                return IItemEntityInteractable.CallbackType.SKIP;
                            }
                        } else {
                            vehicle.toggleLock();
                            player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_KEY_LOCK, new Object[0]));
                            if (hitBox.definition != null && hitBox.definition.action.variable != null && entity.getOrCreateVariable((String)hitBox.definition.action.variable).isActive && !hitBox.definition.action.variable.startsWith("door")) {
                                return IItemEntityInteractable.CallbackType.SKIP;
                            }
                        }
                    }
                }
                return IItemEntityInteractable.CallbackType.NONE;
            }
            case 6: {
                if (!entity.world.isClient() && rightClick) {
                    if (entity instanceof PartSeat) {
                        if (player.isSneaking()) {
                            if (entity.rider != null) {
                                entity.removeRider();
                            }
                        } else if (entity.rider == null) {
                            entity.world.loadEntities(new BoundingBox(player.getPosition(), 8.0, 8.0, 8.0), entity);
                        }
                    } else {
                        master = entity instanceof APart != false ? ((APart)entity).masterEntity : (AEntityF_Multipart<?>)entity;
                        if (player.isSneaking()) {
                            for (APart otherPart : master.allParts) {
                                if (otherPart.rider == null) continue;
                                otherPart.removeRider();
                            }
                        } else {
                            master.world.loadEntities(new BoundingBox(player.getPosition(), 8.0, 8.0, 8.0), master);
                        }
                    }
                }
                return IItemEntityInteractable.CallbackType.NONE;
            }
            case 7: {
                if (!entity.world.isClient() && rightClick) {
                    if (ItemItem.firstPartClicked == null) {
                        if (entity instanceof PartInteractable) {
                            interactable = (PartInteractable)entity;
                            if (interactable.tank != null) {
                                if (interactable.linkedPart == null && interactable.linkedVehicle == null) {
                                    ItemItem.firstPartClicked = interactable;
                                    player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_FUELHOSE_FIRSTLINK, new Object[0]));
                                } else {
                                    player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_FUELHOSE_ALREADYLINKED, new Object[0]));
                                }
                            }
                        }
                    } else if (entity instanceof PartInteractable) {
                        interactable = (PartInteractable)entity;
                        if (interactable.tank != null && !interactable.equals(ItemItem.firstPartClicked)) {
                            if (interactable.linkedPart == null && interactable.linkedVehicle == null) {
                                if (interactable.position.isDistanceToCloserThan(ItemItem.firstPartClicked.position, 16.0)) {
                                    if (interactable.tank.getFluid().isEmpty() || interactable.tank.getFluid().equals(ItemItem.firstPartClicked.tank.getFluid())) {
                                        ItemItem.firstPartClicked.linkedPart = interactable;
                                        InterfaceManager.packetInterface.sendToAllClients(new PacketPartInteractable(ItemItem.firstPartClicked, player));
                                        player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_FUELHOSE_SECONDLINK, new Object[0]));
                                    } else {
                                        player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_FUELHOSE_DIFFERENTFLUIDS, new Object[0]));
                                    }
                                } else {
                                    player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_FUELHOSE_TOOFAR, new Object[0]));
                                }
                            } else {
                                player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_FUELHOSE_ALREADYLINKED, new Object[0]));
                            }
                            ItemItem.firstPartClicked = null;
                        }
                    } else if (vehicle != null) {
                        if (vehicle.position.isDistanceToCloserThan(ItemItem.firstPartClicked.position, 16.0)) {
                            if (vehicle.fuelTank.getFluid().isEmpty() || vehicle.fuelTank.getFluid().equals(ItemItem.firstPartClicked.tank.getFluid())) {
                                ItemItem.firstPartClicked.linkedVehicle = vehicle;
                                InterfaceManager.packetInterface.sendToAllClients(new PacketPartInteractable(ItemItem.firstPartClicked, player));
                                player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_FUELHOSE_SECONDLINK, new Object[0]));
                            } else {
                                player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_FUELHOSE_DIFFERENTFLUIDS, new Object[0]));
                            }
                        } else {
                            player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_FUELHOSE_TOOFAR, new Object[0]));
                        }
                        ItemItem.firstPartClicked = null;
                    }
                }
                return IItemEntityInteractable.CallbackType.NONE;
            }
            case 8: {
                if (!entity.world.isClient() && rightClick && entity instanceof PartEngine) {
                    engine = (PartEngine)entity;
                    if (engine.vehicleOn != null) {
                        if (engine.linkedEngine == null) {
                            if (ItemItem.firstEngineClicked == null) {
                                ItemItem.firstEngineClicked = engine;
                                player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_JUMPERCABLE_FIRSTLINK, new Object[0]));
                            } else if (!ItemItem.firstEngineClicked.equals(engine)) {
                                if (ItemItem.firstEngineClicked.vehicleOn.equals(engine.vehicleOn)) {
                                    ItemItem.firstEngineClicked = null;
                                    player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_JUMPERCABLE_SAMEVEHICLE, new Object[0]));
                                } else if (engine.position.isDistanceToCloserThan(ItemItem.firstEngineClicked.position, 15.0)) {
                                    engine.linkedEngine = ItemItem.firstEngineClicked;
                                    ItemItem.firstEngineClicked.linkedEngine = engine;
                                    InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(engine, ItemItem.firstEngineClicked));
                                    InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(ItemItem.firstEngineClicked, engine));
                                    ItemItem.firstEngineClicked = null;
                                    player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_JUMPERCABLE_SECONDLINK, new Object[0]));
                                } else {
                                    ItemItem.firstEngineClicked = null;
                                    player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_JUMPERCABLE_TOOFAR, new Object[0]));
                                }
                            }
                        } else {
                            player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_JUMPERCABLE_ALREADYLINKED, new Object[0]));
                        }
                    }
                }
                return IItemEntityInteractable.CallbackType.NONE;
            }
            case 9: {
                if (rightClick && entity instanceof EntityVehicleF_Physics) {
                    ((EntityVehicleF_Physics)entity).electricPower = ((EntityVehicleF_Physics)entity).batteryCapacityVar.currentValue * 0.85715;
                    if (!entity.world.isClient()) {
                        InterfaceManager.packetInterface.sendToPlayer(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_VEHICLE_JUMPERPACK, new Object[0]), player);
                        if (!player.isCreative()) {
                            player.getInventory().removeFromSlot(player.getHotbarIndex(), 1);
                        }
                        return IItemEntityInteractable.CallbackType.ALL;
                    }
                }
                return IItemEntityInteractable.CallbackType.NONE;
            }
            case 10: {
                if (!rightClick || entity.world.isClient()) ** GOTO lbl215
                if (((JSONItem)this.definition).repair.repairableParts == null) ** GOTO lbl189
                if (!(entity instanceof APart)) {
                    InterfaceManager.packetInterface.sendToPlayer(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_REPAIR_WRONGTYPE, new Object[0]), player);
                    return IItemEntityInteractable.CallbackType.NONE;
                }
                partMatches = false;
                for (String typePrefix : ((JSONItem)this.definition).repair.repairableParts) {
                    if (!((JSONPart)((APart)entity).definition).generic.type.startsWith(typePrefix)) ** GOTO lbl185
                    partMatches = true;
                    ** GOTO lbl193
lbl185:
                    // 1 sources

                    if (partMatches) continue;
                    InterfaceManager.packetInterface.sendToPlayer(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_REPAIR_WRONGTYPE, new Object[0]), player);
                    return IItemEntityInteractable.CallbackType.NONE;
                }
                ** GOTO lbl193
lbl189:
                // 1 sources

                if (vehicle == null) {
                    InterfaceManager.packetInterface.sendToPlayer(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_REPAIR_WRONGTYPE, new Object[0]), player);
                    return IItemEntityInteractable.CallbackType.NONE;
                }
                entity = vehicle;
lbl193:
                // 3 sources

                if (entity.repairCooldownTicks == 0) {
                    if (!entity.outOfHealth || ((JSONItem)this.definition).repair.canRepairTotaled) {
                        if (!(entity.damageVar.currentValue != 0.0 || entity instanceof PartEngine && ((PartEngine)entity).hoursVar.currentValue != 0.0)) {
                            InterfaceManager.packetInterface.sendToPlayer(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_REPAIR_NONEED, new Object[0]), player);
                            return IItemEntityInteractable.CallbackType.NONE;
                        }
                        amountRepaired = ((JSONItem)this.definition).repair.amount;
                        if (vehicle.damageVar.currentValue < amountRepaired) {
                            amountRepaired = entity.damageVar.currentValue;
                        }
                        newDamage = entity.damageVar.currentValue - amountRepaired;
                        entity.damageVar.setTo(newDamage, true);
                        if (entity instanceof PartEngine) {
                            ((PartEngine)entity).hoursVar.setTo(0.0, true);
                        }
                        entity.repairCooldownTicks = 200;
                        InterfaceManager.packetInterface.sendToPlayer(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_REPAIR_PASS, new Object[]{amountRepaired, (double)((AJSONInteractableEntity)entity.definition).general.health - newDamage, ((AJSONInteractableEntity)entity.definition).general.health}), player);
                        entity.repairedVar.setActive(true, true);
                        if (!player.isCreative()) {
                            player.getInventory().removeFromSlot(player.getHotbarIndex(), 1);
                        }
                    } else {
                        InterfaceManager.packetInterface.sendToPlayer(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_REPAIR_TOTALED, new Object[0]), player);
                    }
                } else {
                    InterfaceManager.packetInterface.sendToPlayer(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_REPAIR_TOOSOON, new Object[0]), player);
                }
lbl215:
                // 4 sources

                return IItemEntityInteractable.CallbackType.NONE;
            }
        }
        return IItemEntityInteractable.CallbackType.SKIP;
    }

    @Override
    public boolean onBlockClicked(AWrapperWorld world, IWrapperPlayer player, Point3D position, ABlockBase.Axis axis) {
        if (((JSONItem)this.definition).item.type == JSONItem.ItemComponentType.PAINT_GUN) {
            if (!world.isClient()) {
                Object tile = world.getTileEntity(position);
                if (tile instanceof TileEntityDecor) {
                    player.sendPacket(new PacketEntityGUIRequest((AEntityB_Existing)tile, player, PacketEntityGUIRequest.EntityGUIType.PAINT_GUN));
                    return true;
                }
                if (tile instanceof TileEntityPole) {
                    TileEntityPole pole = (TileEntityPole)tile;
                    axis = ABlockBase.Axis.getFromRotation(player.getYaw(), ((JSONPoleComponent)pole.definition).pole.allowsDiagonals).getOpposite();
                    if (pole.components.containsKey((Object)axis)) {
                        player.sendPacket(new PacketEntityGUIRequest(pole.components.get((Object)axis), player, PacketEntityGUIRequest.EntityGUIType.PAINT_GUN));
                    }
                    return true;
                }
            }
        } else if (((JSONItem)this.definition).item.type.equals((Object)JSONItem.ItemComponentType.BOOKLET) && !world.isClient()) {
            player.sendPacket(new PacketGUIRequest(player, PacketGUIRequest.GUIType.BOOKLET));
        }
        return false;
    }

    @Override
    public boolean onUsed(AWrapperWorld world, IWrapperPlayer player) {
        if (((JSONItem)this.definition).item.type.equals((Object)JSONItem.ItemComponentType.BOOKLET)) {
            if (!world.isClient()) {
                player.sendPacket(new PacketGUIRequest(player, PacketGUIRequest.GUIType.BOOKLET));
            }
        } else if (((JSONItem)this.definition).item.type.equals((Object)JSONItem.ItemComponentType.Y2K_BUTTON) && !world.isClient() && player.isOP()) {
            if (player.isSneaking()) {
                for (EntityVehicleF_Physics vehicle : world.getEntitiesOfType(EntityVehicleF_Physics.class)) {
                    player.displayChatMessage(LanguageSystem.SYSTEM_DEBUG, "Vehicle:" + vehicle + " present at " + vehicle.position);
                }
            } else {
                for (EntityVehicleF_Physics vehicle : world.getEntitiesOfType(EntityVehicleF_Physics.class)) {
                    vehicle.runningLightVar.setTo(0.0, true);
                    vehicle.headLightVar.setTo(0.0, true);
                    vehicle.navigationLightVar.setTo(0.0, true);
                    vehicle.strobeLightVar.setTo(0.0, true);
                    vehicle.taxiLightVar.setTo(0.0, true);
                    vehicle.landingLightVar.setTo(0.0, true);
                    vehicle.throttleVar.setTo(0.0, true);
                    vehicle.parkingBrakeVar.setTo(0.0, true);
                    vehicle.engines.forEach(engine -> engine.magnetoVar.setTo(0.0, true));
                }
                player.displayChatMessage(LanguageSystem.SYSTEM_DEBUG, "Stopped all vehicles.");
            }
        }
        return true;
    }

    @Override
    public int getTimeToEat() {
        return ((JSONItem)this.definition).item.type.equals((Object)JSONItem.ItemComponentType.FOOD) ? ((JSONItem)this.definition).food.timeToEat : 0;
    }

    @Override
    public boolean isDrink() {
        return ((JSONItem)this.definition).food.isDrink;
    }

    @Override
    public int getHungerAmount() {
        return ((JSONItem)this.definition).food.hungerAmount;
    }

    @Override
    public float getSaturationAmount() {
        return ((JSONItem)this.definition).food.saturationAmount;
    }

    @Override
    public List<JSONPotionEffect> getEffects() {
        return ((JSONItem)this.definition).food.effects;
    }
}

